# +--------------------------------------------------------------------------------+
# | Einfuehrung in die Oekonometrie                                                |
# | Korrelationsanalyse und lineare Mehrfachregression                             |
# | Beispiel "Verkaufspreis gebrauchter PKW vom Typ Golf" (doc_gebrauchtwagen.pdf) |
# | R. Schuhr 22.03.2012                                                           |
# + -------------------------------------------------------------------------------+


# Einlesen der Daten aus der Datei "gebrauchtwagen.r" und Definition des Data-Frames "golf"
# -----------------------------------------------------------------------------------------
golf <- read.table("gebrauchtwagen.r",header=TRUE)
dim(golf)
golf[1:10,]
attach(golf)


# Explorative Datenanalyse: Streudiagramm, Korrelation, Box-Plots
# ---------------------------------------------------------------
# Streudiagramme 
par(mfrow=c(1,3), plt=c(0.17,0.95,0.2,0.9))
plot(alter, preis, cex.lab=1.2)
plot(kilstand, preis, cex.lab=1.2)
plot(tuev, preis,cex.lab=1.2)
par(mfrow=c(1,1))

# Box-Plots
par(mfrow=c(1,2), plt=c(0.17,0.95,0.2,0.9))
boxplot(preis~sonderaus1, notch=TRUE, names=c("kein ABS","ABS"), cex.lab=1.1)
boxplot(preis~sonderaus2, notch=TRUE, names=c("kein Schiebedach","Schiebedach"), cex.lab=1.1)
par(mfrow=c(1,1))

# Korrelationsmatrix (Bravais-Pearson-Korrelation)
cor(golf[,1:4]) 
# Unterscheidet sich der Korrelationskoeffizient "r(preis,tuev)" signifikant von null?
cor.test(preis, tuev)  


# Verwendete R-Funktionen
?cov
?cor
?cor.test
?boxplot


# Regressionsanalyse: Schaetzung verschiedener Regressionsmodelle
# --------------------------------------------------------------
modell.1 <- lm(preis~alter+kilstand+tuev+sonderaus1+sonderaus2, data=golf)
oder...
modell.1 <- lm(preis~., data=golf)
summary(modell.1)
confint(modell.1, level = 0.95)

# Entfernen insignifikanter Regressoren aus dem Modell
modell.2 <- lm(preis~alter+kilstand, data=golf)
summary(modell.2)
confint(modell.2, level = 0.95)

# F-Test der Hypothese H0: b.tuev = b.sonderaus1 = b.sonderaus2 = 0
anova(modell.2, modell.1)

# Variablen der Klasse "modell.2"
modell.2$coefficients
modell.2$fitted.values
modell.2$residuals

# Plot der geschaetzten Regressionsfunktion
plot(modell.2$fitted.values, preis, xlab="Angepasste Werte", ylab="PKW-Preis", main="Regressionsfunktion")
lines(preis,preis)

# Residuen-Plot - Es wird ein "lack-of-fit" sichtbar.
plot(modell.2$fitted.values, modell.2$residuals, xlab="angepasste Werte", ylab="Residuen", main="Residuenplot")
abline(h=0.0)
plot(modell.2,1)

# Erweiterung des Modells durch Polynome (Polynome 2. Ordnung)
alter2 <- alter**2
kilstand2 <- kilstand**2
modell.3 <- lm(preis~alter+alter2+kilstand+kilstand2, data=golf)
summary(modell.3)
confint(modell.3, level = 0.95)

# F-Test der Hypothese H0: b.alter2 = b.kilstand2 = 0
anova(modell.2, modell.3)

# Modellvergleich mit dem AIC-Kriterium
AIC(modell.1)
AIC(modell.2)
AIC(modell.3)

# Variablen der Klasse "modell.3"
modell3$coefficients
modell3$fitted.values
modell3$residuals

# Plot der geschaetzten Regressionsfunktion
plot(modell.3$fitted.values, preis, xlab="Angepasste Werte", ylab="PKW-Preis", main="Regressionsfunktion")
lines(preis,preis)

# Residuen-Plot
plot(modell.3$fitted.values, modell.3$residuals, xlab="angepasste Werte", ylab="Residuen", main="Residuenplot")
abline(h=0.0)

# Verwendete R-Funktionen
?lm
?confint
?summary
?poly

# Residuen-Normalverteilungscheck
# -------------------------------
studres <- rstudent(modell.3) # Berechnung der "studentisierten" Residuen
qqnorm(studres)  # QQ-Plot der "studentisierten" Residuen
qqline(studres)
shapiro.test(studres) # Shapiro-Wilks-Tests
# Die studentisierten Residuen sind symmetrisch, aber nicht normalverteilt, denn... 
hist(studres, freq=FALSE, ylim=c(0,0.5))
studres.den <- density(studres, kernel="gaussian", adjust=1) # Kerndichteschaetzung
lines(studres.den, col="red")
x <- seq(-4,4,0.1)
benzin.nd <- dnorm(x,0,sd(studres)) # Dichte der Normalverteilung
lines(x, benzin.nd, col="blue")

# Konfidenz- und Prognoseintervalle - Vorsicht beim Prognoseintervall
# -------------------------------------------------------------------
plim <- predict(modell.3, newdata=golf, interval="prediction", level = 0.95)
clim <- predict(modell.3, newdata=golf, interval="confidence", level = 0.95)
# Plot der Intervalle
plot(plim[,1], golf$preis, xlab="Angepasste Werte", ylab="PKW-Preis", main="Regressionsfunktion")
lines(plim[,1], plim[,1])
lines(plim[,1], plim[,2], col="green")
lines(plim[,1], plim[,3], col="green")
lines(clim[,1], clim[,2], col="red")
lines(clim[,1], clim[,3], col="red")

# Verwendete R-Funktionen
?qqnorm
?qqline
?shapiro.test
?rstudent
?hist
?density
?predict
?predict.lm


library(MASS) # Library von Venables & Ripley

# Schrittweise Auswahl eines Teilmodells mittels AIC oder BIC
# -----------------------------------------------------------
# Schrittweise Variablenauswahl (down-up) mit AIC-Kriterium
modell.4 <- lm(preis~alter+alter2+kilstand+kilstand2+sonderaus1+sonderaus2, data=golf)
summary(modell.4)
modell.step.aic <- stepAIC(modell.4, direction="both", k=2, trace=F)
modell.step.aic$anova
summary(modell.step.aic)
# Schrittweise Variablenauswahl (down-up) mit BIC-Kriterium
dim(golf)
modell.step.bic <- stepAIC(modell.4, direction="both", k=log(172), trace=F)
modell.step.bic$anova
summary(modell.step.bic)
# Schrittweise Variablenauswahl (up-down) mit BIC-Kriterium
modell.min <- lm(preis~1, data=golf)
modell.step.up.bic <- stepAIC(modell.min, 
scope = list(upper =~alter+alter2+kilstand+kilstand2+sonderaus1+sonderaus2, lower = ~1),
direction="both", trace=F, k=log(172))
modell.step.up.bic$anova
summary(modell.step.up.bic)
# Verwendete R-Funktionen
?stepAIC


detach(golf) # Ende