# +------------------------------------------------------------------------+
# | Einfuehrung in die Oekonometrie                                        |
# | Explorative Datenanalyse                                               |
# | Beispiel "Mietspiegel Muenchen 1999" (doc_mietspiegel99.pdf)           |
# | R. Schuhr 15.03.2012                                                   |
# + -----------------------------------------------------------------------+


# Einlesen der Daten aus der Datei "mietspiegel99.r" und Definition des Data-Frames "msm"
# ---------------------------------------------------------------------------------------
msm <- read.table("mietspiegel99.r",header=TRUE)
dim(msm)
msm[1:10,]
# Alternatives Vorgehen: Daten aus der Datei "mietspiegel99.csv" 
msm <- read.csv2("mietspiegel99.csv",header=TRUE)
dim(msm)
msm[1:10,]
# Verwendete R-Funktion
?read.table   # Siehe auch "scan"
?read.csv2


# Attachieren des Data-Frames
# ---------------------------
msm[,1]
msm$miete
miete
attach(msm)
miete
# Verwendete R-Funktion
?attach  # Siehe auch "detach"


# Explorative Datenanalyse: Haeufigkeitstabellen
# ---------------------------------------------
bad
table(bad)  # Absolute Haeufigkeiten der Wohnungen mit Normal- und Komfortbad
table(bad)/length(bad)  # relative Haeufigkeiten
100*table(bad)/length(bad)  # relative Haeufigkeiten in Prozent
msm.n <- length(bad)
round(100*table(bad)/msm.n, digits=1)

table(bad,kueche)  # (Kreuz-) Kontingenztabellen
round(100*table(bad,kueche)/msm.n, digits=1)
table(bad,kueche,zh)
round(100*table(bad,kueche,zh)/msm.n, digits=1)

# Diskretisierung stetiger Variablen (Festlegeung von Zaehlklassen)
Quadratmetermiete <- cut(mieteqm,breaks=c(0,10,20,50)) 
Quadratmetermiete 
levels(Quadratmetermiete) <- c("niedrig","mittel","hoch")
Quadratmetermiete 

Wohnungsgroesse <- cut(flaeche,breaks=c(0,100,200))
levels(Wohnungsgroesse) <- c("klein","gross")
table(Quadratmetermiete,Wohnungsgroesse)
round(100*table(Quadratmetermiete,Wohnungsgroesse)/msm.n, digits=1)

# Verwendete R-Funktionen
?table
?round
?cut
?levels


# Explorative Datenanalyse: Stab- und Tortendiagramme
# --------------------------------------------------- 
barplot(100*table(Quadratmetermiete)/msm.n)
barplot(100*table(Quadratmetermiete)/msm.n, col="lightblue", density=32, 
        main="Quadratmetermieten in Muenchen", xlab="Miete", ylab="Prozent")
pie(100*table(Quadratmetermiete)/msm.n)
pie(100*table(Quadratmetermiete)/msm.n, col=c("lightblue","lightgreen","yellow"),
        main="Quadratmetermieten in Muenchen")
# Verwendete R-Funktionen
?barplot
?pie


# Explorative Datenanalyse: Histogramme und Kerndichteschaetzung
# -------------------------------------------------------------
hist(mieteqm)
hist(mieteqm, breaks=c(0,5,10,15,20,25,30,40), xlab="Miete", ylab="Dichte", main="Quadratmetermieten in Muenchen")
hist(mieteqm, breaks=35, xlab="Miete", ylab="Haeufigkeit", main="Quadratmetermieten in Muenchen")
hist(mieteqm, breaks=35, freq=FALSE, xlab="Miete", ylab="Dichte", main="Quadratmetermieten in Muenchen")

mieteqm.den <- density(mieteqm, kernel="gaussian") # "Glaettung" der Haeufigkeitsdichte mittels "Kernschaetzer"
mieteqm.den 
plot(mieteqm.den, xlab="Miete", ylab="Dichte", main="Kerndichteschaetzung")
mieteqm.den <- density(mieteqm, kernel="gaussian", adjust=0.5)
plot(mieteqm.den, xlab="Miete", ylab="Dichte", main="Kerndichteschaetzung")
mieteqm.den <- density(mieteqm, kernel="gaussian", adjust=1.5)
plot(mieteqm.den, xlab="Miete", ylab="Dichte", main="Kerndichteschaetzung")

hist(mieteqm, breaks=35, freq=FALSE, xlab="Miete", ylab="Dichte", main="Quadratmetermieten in Muenchen")
lines(mieteqm.den, col="red")

# Verwendete R-Funktionen
?hist
?density
?plot
?lines


# Explorative Datenanalyse: Empirische Verteilungsfunktion (empirical cumulative distribution function - ecdf)
# -------------------------------------------------------------------------------------------------------------
ecdf(mieteqm)
plot(ecdf(mieteqm), do.points=FALSE, verticals=TRUE)
plot(ecdf(mieteqm), do.points=FALSE, verticals=TRUE, col.hor=4, col.ver=4, 
     main="Empirische Verteilungsfunktion", xlab="x", ylab=expression(hat(F)(x)))

# Verwendete R-Funktionen
?ecdf
?plot
?plot.stepfun


# Explorative Datenanalyse: Kennzahlen
# ------------------------------------
mean(mieteqm)       # Arithmetisches Mittel
var(mieteqm)        # Stichprobenvarianz
sqrt(var(mieteqm))  # Standardabweichung
sd(mieteqm)         # ...kuerzer
median(mieteqm)     # Median
summary(mieteqm)    # Quartile 


# Explorative Datenanalyse: Boxplots
# ----------------------------------
boxplot(mieteqm)

boxplot(mieteqm, main="Boxplot: Quadratmetermieten in Muenchen", ylab="DM")

boxplot(mieteqm~kueche, main="Quadratmetermieten in Muenchen", 
        xlab="Normale (links) und gehobene (rechts) Kuechenausstattung", ylab="DM")

boxplot(mieteqm~kueche, notch=TRUE, main="Quadratmetermieten in Muenchen", 
        xlab="Normale (links) und gehobene (rechts) Kuechenausstattung", ylab="DM")

boxplot(mieteqm~bad, notch=TRUE, main="Quadratmetermieten in Muenchen", 
        xlab="Normale (links) und gehobene (rechts) Badausstattung", ylab="DM")

boxplot(mieteqm~zh, notch=TRUE, main="Quadratmetermieten in Muenchen", 
        xlab="Ohne (links) und mit (rechts) Zentralheizung", ylab="DM")

boxplot(mieteqm~kueche+bad, notch=TRUE, main="Quadratmetermieten in Muenchen", 
        xlab="verschiedene Bad- und Kuechenausstattungen", ylab="DM")

boxplot(mieteqm~kueche+bad+zh, main="Quadratmetermieten in Muenchen", 
        xlab="verschiedene Wohnungsausstattungen", ylab="DM")

# Verwendete R-Funktion
?boxplot
?boxplot.stats  # Erlaeuterungen zur Funktion "boxplot"


# Explorative Datenanalyse: Test auf Normalverteilung
# ---------------------------------------------------
mieteqm.den <- density(mieteqm, kernel="gaussian", adjust=1.5)
hist(mieteqm, breaks=35, freq=FALSE, xlab="Miete", ylab="Dichte", main="Quadratmetermieten in Muenchen")
lines(mieteqm.den, col="red")
# Liegt eine Normalverteilung vor?
qqnorm(mieteqm)        # Normal-QQ-Plot
qqline(mieteqm)
#
shapiro.test(mieteqm)  # Shapiro-Wilks-Test 

# Verwendete R-Funktion
?qqnorm
?shapiro.test

detach(msm) # Ende
