# +------------------------------------------------------------------------+
# | Einfuehrung in die Oekonometrie                                        |
# | Explorative Datenanalyse und t-Test                                    |
# | Beispiel "Benzinverbrauch" (doc_benzinverbrauch.pdf)                   |
# | R. Schuhr 15.03.2012                                                   |
# + -----------------------------------------------------------------------+


# Einlesen der Daten aus der Datei "benzinverbrauch.r" und Definition der Variablen "benzin"
# ------------------------------------------------------------------------------------------
benzin <- scan("benzinverbrauch.r")
benzin
# Verwendete R-Funktion
?scan   # Siehe auch "read.csv2" und "read.table"  


# Kennzahlen
# ----------
mean(benzin)      # arithmetischer Mittelwert
var(benzin)       # Stichprobenvarianz
sd(benzin)        # Stichprobenstandardabweichung


# t-Test von Hypothesen ueber den mittleren Benzinverbrauch
# ---------------------------------------------------------
# Zweiseitger Test
# H0: mu = 7.6  versus  H1: mu <> 7.6    
t.test(benzin, alternative="two.sided", mu=7.6, conf.level = 0.95)

# Testdurchfuehrung mittels (elektronischer) Tabelle der t-Verteilung
qt(0.025,24)    # 0.025-Quantil der t(24)-Verteilung
qt(0.975,24)    # 0.975-Quantil der t(24)-Verteilung
1-(0.03212/2)
qt(0.98394,24)  # 0.98394-Quantil der t(24)-Verteilung

# Einseitger Test
# H0: mu <= 7.6  versus  H1: mu > 7.6  
t.test(benzin, alternative="greater", mu=7.6, conf.level = 0.95)

# Testdurchfuehrung mittels (elektronischer) Tabelle der t-Verteilung
qt(0.95,24)        # 0.975-Quantil der t(24)-Verteilung
pt(2.2751,24)      # Verteilungsfunktion der t(24)-Verteilung
1-pt(2.2751,24)    # p-Wert 
qt((1-0.01606),24) # 0.98394-Quantil der t(24)-Verteilung

# Verwendete R-Funktion
?t.test  
?qt  # siehe auch dt, pt, rt


# Validierung der Testergebnisse: Test auf Normalverteilung
# ---------------------------------------------------------
#
# Histogramm und Kerndichteschaetzung
hist(benzin, freq=FALSE)
hist(benzin, freq=FALSE, ylim=c(0,1), xlab="Benzinverbrauch", ylab="Dichte", main="")
benzin.den <- density(benzin, kernel="gaussian") 
lines(benzin.den, col="red")
# Approximation der Dichte durch die Dichte der Normalverteilung
x <- seq(6.5,9,0.025)
x
benzin.nd <- dnorm(x, mean(benzin), sd(benzin))
lines(x, benzin.nd, col="blue")
#
# Empirische Verteilungsfunktion
ecdf(benzin)
plot(ecdf(benzin))
plot(ecdf(benzin), do.points=FALSE, verticals=TRUE, main="Empirische Verteilungsfunktion", xlab="x", ylab="v(x)")
# Approximation der Verteilungsfunktion durch die Verteilungsfunktion der Normalverteilung
benzin.nv <- pnorm(x, mean(benzin), sd(benzin))
lines(x,benzin.nv, col="blue")
#
# Normal-Probability-Plot (Quantil-Quantil-Plot)
qqnorm(benzin)
qqline(benzin)
# Shapiro-Wilks-Test auf Normalverteilung 
shapiro.test(benzin)

# Verwendete R-Funktion
?density
?dnorm 
?pnorm
?ecdf
?qqnorm
?qqline  
?shapiro.test

# Ende

