# +-------------------------------------------------------------------------+
# | Einfuehrung in die Oekonometrie                                         |
# | Lineare Einfachregression                                               |
# | Beispiel "Konsumfunktion" (doc_konsumfunktion.pdf)                      |
# | R. Schuhr 19.03.2012                                                    |
# + ------------------------------------------------------------------------+


# Einlesen der Daten aus der Datei "konsumfunktion.r" und Definition des Data-Frames "kf"
# ---------------------------------------------------------------------------------------
kf <- read.table("konsumfunktion.r",header=TRUE)
kf
attach(kf)


# Zeitreihenplot und Streudiagramm der Variablen
# ----------------------------------------------
plot(jahr, einkommen, type="b", xlab="Jahr", ylab="Mrd. DM", main="Privater Verbrauch und verfuegbares Einkommen")
lines(jahr, konsum, type="b", col="blue") 
plot(einkommen, konsum, xlab="Verfuegbares Einkommen in Mrd. DM", ylab="Privater Konsum in Mrd. DM", main="Streudiagramm")


# Zusammenhangsanalyse: Kovarianz. Korrelation
# --------------------------------------------
# Kovarianz und Korrelation
cov(einkommen,konsum) # Kovarianz der Variablen "einkommen" und "konsum"
cor(einkommen,konsum) # Bravais-Pearson-Korrelationskoeffizient

# alternative Vorgehensweise ...
cov(kf[,2:3])  # Varianz-Kovarianz-Matrix
var(konsum)    # Auf der Hauptdiagonalen der Matrix stehen die Stichprobenvarianzen
var(einkommen) # der Variablen, abseits der Hauptdiagonalen steht die Kovarianz
#
cor(kf[,2:3])  # Korrelationsmatrix

# Unterscheidet sich der Korrelationskoeffizient signifikant von null?
# H0: rho = 0  versus  H1: rho <> 0
cor.test(einkommen, konsum)  

# Verwendete R-Funktionen
?cov
?cor
?cor.test


# Lineare Einfachregression - Kompakt
# -----------------------------------
kf.modell <- lm(konsum~einkommen, data=kf)
summary(kf.modell)

# Ergaenzende Funktionen
vcov(kf.modell)                # Varianz-Kovarianz-Matrix der OLS-Schaetzungen
confint(kf.modell, level=0.95) # Konfidenzintervalle 
anova(kf.modell)               # ANOVA

# Variablen der Klasse "kf.modell"
kf.modell$coefficients
kf.modell$fitted.values
kf.modell$residuals
konsum == kf.modell$fitted.values + kf.modell$residuals  # Test der Ergebnisse

# Verwendete R-Funktionen
?lm
?summary
?vvcov
?confint
?anova

# Zeitreihenplot mit Konsumfunktion
plot(jahr, konsum, type="b", xlab="Jahr", ylab="Mrd. DM", main="Privater Verbrauch und Konsumfunktion")
lines(jahr, kf.modell$fit, type="l", col="blue") 

# Streudiagramm mit Konsumfunktion
plot(einkommen, konsum, type="p",  xlab="Verfuegbares Einkommen in Mrd. DM", ylab="Privater Konsum in Mrd. DM", main="Konsumfunktion") 
lines(einkommen, kf.modell$fit, col="blue")

# Residuendiagramm
plot(einkommen, kf.modell$res, type="p",  xlab="Einkommen", ylab="Residuen", main="Residuenplot") 
abline(h=0)
plot(kf.modell$fit, kf.modell$res, type="p",  xlab="Fitted Values", ylab="Residuen", main="Residuenplot") 
abline(h=0)

# Verwendete R-Funktionen
?plot
?lines
?abline

# Lineare Regressionsanalyse: Konfidenz- und Prognoseintervalle
# -------------------------------------------------------------
# Konfidenzintervall
clim <- predict(kf.modell, newdata=kf, interval="confidence", level = 0.95)
clim
plot(einkommen, konsum, xlab="Verfuegbares Einkommen in Mrd. DM", ylab="Privater Konsum in Mrd. DM", main="Konsumfunktion")
lines(einkommen, clim[,1], col="blue")
lines(einkommen, clim[,2], col="red")
lines(einkommen, clim[,3], col="red")
# Prognoseintervall
plim <- predict(kf.modell, newdata=kf, interval="prediction", level = 0.95)
plim
plot(einkommen, konsum, xlab="Verfuegbares Einkommen in Mrd. DM", ylab="Privater Konsum in Mrd. DM", main="Konsumfunktion")
lines(einkommen, plim[,1], col="blue")
lines(einkommen, plim[,2], col="darkgreen")
lines(einkommen, plim[,3], col="darkgreen")

# "Echte" Prognosen
newkf <- data.frame(einkommen=c(1300,1350,1400))
newkf
predict(kf.modell, newdata=newkf, interval="prediction", level = 0.90)


detach(kf) # Ende