# +--------------------------------------------------------------------------+
# | Einfuehrung in die Oekonometrie                                          |
# | Lineare Einfachregression - Schritt fuer Schritt                         |
# | Beispiel "Konsumfunktion" (doc_konsumfunktion.pdf)                       |
# | R. Schuhr 19.03.2012                                                     |
# + -------------------------------------------------------------------------+


# Einlesen der Daten aus der Datei "konsumfunktion.r" und Definition des Data-Frames "kf"
# ---------------------------------------------------------------------------------------
kf <- read.table("konsumfunktion.r",header=TRUE)
kf
attach(kf)


# Zeitreihenplot und Streudiagramm der Variablen
# ----------------------------------------------
plot(jahr, einkommen, type="b", xlab="Jahr", ylab="Mrd. DM", main="Privater Verbrauch und verfuegbares Einkommen")
lines(jahr, konsum, type="b", col="blue") 
plot(einkommen, konsum, xlab="Verfuegbares Einkommen in Mrd. DM", ylab="Privater Konsum in Mrd. DM", main="Streudiagramm")


# Lineare Einfachregression - Kompakt
# -----------------------------------
kf.modell <- lm(konsum~einkommen, data=kf)
summary(kf.modell)


# Lineare Einfachregression - Schritt fuer Schritt
# -----------------------------------------------
# Matrizen
X <- matrix(1,19,2) 
X
X[,2] <- einkommen
X
dim(X)
y <- matrix(konsum,19,1) 
y
dim(y)
konsum   # ... zum Vergleich
dim(konsum)
# Verwendete R-Funktionen
?matrix
?dim

# Berechnung der OLS-Schtzwerte
Xt <- t(X) # Transponieren von X
Xt
dim(Xt)
XtX <- Xt%*%X # Kreuzproduktmatrix, Matrizenprodukt %*%
XtX
Xty <- Xt%*%y
Xty
b <- solve(XtX,Xty) # Berechnen der OLS-Schtzwerte fuer b0 und b1 durch Lsen 
b                   # der Normalgleichungen XtX%*%b=Xty

# oder ...

XtXinv <- solve(XtX) # Invertieren einer regulren quadratischen Kreuzproduktmatrix
XtXinv
XtX%*%XtXinv # Probe
b <- XtXinv%*%Xty # Berechnen der OLS-Schtzwerte fuer b0 und b1
b

# Verwendete R-Funktion
?t
?solve

# Hat-Matrix H
H <- X%*%XtXinv%*%Xt 
dim(H)
all.equal(H,t(H))  # Symmetrie-Probe
all.equal(H,H%*%H) # Idempotenz-Probe

# Graphiken
fit <- X%*%b # Geschtzte (angepasste) Werte des Regressanden und Residuen
fit
# oder ...
fit <- H%*%y            
fit
res <- y-fit # Residuen
res

# Zeitreihenplot mit Konsumfunktion
plot(jahr, konsum, type="b", xlab="Jahr", ylab="Mrd. DM", main="Privater Verbrauch und Konsumfunktion")
lines(jahr, fit, type="l", col="blue") 

# Streudiagramm mit Konsumfunktion
plot(einkommen, konsum, type="p",  xlab="Verfuegbares Einkommen in Mrd. DM", ylab="Privater Konsum in Mrd. DM", main="Konsumfunktion") 
lines(einkommen, fit, col="blue")

# Residuendiagramm
plot(einkommen, res, type="p",  xlab="Einkommen", ylab="Residuen", main="Residuenplot") 
abline(h=0)
plot(fit, res, type="p",  xlab="Fitted Values", ylab="Residuen", main="Residuenplot") 
abline(h=0)

# Verwendete R-Funktionen
?all.equal
?plot
?lines
?abline

# Streuungszerlegung
TSS <- sum((konsum-mean(konsum))**2) # total sum of squares
ESS <- sum((fit-mean(fit))**2) # regression sum of squares
RSS <- sum(res**2) # residual sum of squares
TSS
ESS+RSS
ESS
RSS
R2  <- ESS/TSS # Bestimmtheitsmass
R2
# oder ...
R2  <- 1-(RSS/TSS)
R2

# Standardfehler der Schtzungen
E.Var <- RSS/(19-2) # Schtzung der Strvarianz
E.Var
E.Sig <- E.Var**0.5 # Strstandardabweichung
E.Sig
b.Var <- E.Var*XtXinv # Varianz-Kovarianz-Matrix der geschtzten Regressionskoeffizienten
b.Var
diag(b.Var) # Varianzen der geschtzten Regressionskoeffizienten
b.Sig <- sqrt(diag(b.Var)) # Standardfehler der geschtzten Regressionskoeffizienten
b.Sig

# t-Tests
t0 <- b[1,1] / b.Sig[1] # Test der Hypothese H0: b0==0 mit alpha=0.05
tkrit <- qt(0.975, 19-2)
t0
tkrit
abs(t0) >= tkrit # H0 wird nicht verworfen. 
t1 <- b[2,1] / b.Sig[2] # Test der Hypothese H0: b1==0 mit alpha=0.05
t1
tkrit
abs(t1) >= tkrit # H0 wird verworfen. 
# Verwendete R-Funktionen
?diag
?qt
?abs


# Lineare Regression selbst programmieren
# ---------------------------------------
linreg <- function(z,D) { solve( t(D)%*%D , t(D)%*%z ) }
# Anwendung
linreg(y, X)


detach(kf) # Ende