# +------------------------------------------------------------------------+
# | Einfuehrung in die Oekonometrie                                        |
# | Explorative Datenanalyse und Zwei-Stichproben-Tests                    |
# | Beispiel "Schaetzung der Laenge eines Hoersaales" (doc_hoersaal.pdf)   |
# | R. Schuhr 15.03.2012                                                   |
# + -----------------------------------------------------------------------+


# Einlesen der Daten aus der Datei "hoersaal.r" und Definition des Data-Frames "data"
# -----------------------------------------------------------------------------------
data <- read.table("hoersaal.r",header=TRUE)
data
# Verwendete R-Funktion
?read.table   # Siehe auch "read.csv2" und "scan"


# Variablendefinition und Datentransformation
# -------------------------------------------
data$meter_fuss
data[data$meter_fuss==1,1]
meter <- data[data$meter_fuss==1,1]*3.28084 # Umrechnung in Fuss
meter
fuss  <- data[data$meter_fuss==2,1]
fuss


# Explorative Datenanalyse: Quartile und Boxplots
# -----------------------------------------------
summary(meter) # Quartile Datensatz 1
summary(fuss)  # Quartile Datensatz 2

# Box-Plots der beiden Datensaetzes 
boxplot(meter,fuss)

# Gekerbte Box-Plots
boxplot(meter,fuss, notch=TRUE)
boxplot(meter,fuss, notch=TRUE, main="Schaetzungen der Laenge eines Hoersaales", 
        xlab="Schaetzungen in Meter (links) bzw. Fuss (rechts)", ylab="Fuss")

# Verwendete R-Funktionen
?summary
?boxplot
?boxplot.stats  # Erlaeuterungen zur Funktion "boxplot"


# Zwei-Stichproben-Tests: Mittelwert- und Varianzvergleiche
# ---------------------------------------------------------
mean(meter) # arithmetischer Mittelwert
var(meter)  # Stichprobenvarianz
sd(meter)   # Stichprobenstandardabweichung
mean(fuss)
var(fuss)
sd(fuss)

# Hypothesen des Mittelwertvergleichs
# H0: mu1 = mu2       versus    H1: mu1 <> mu2       O D E R
# H0: mu1 - mu2 = 0   versus    H1: mu1 -  mu2 <> 0   
# Zwei-Stichproben-t-Test
t.test(meter,fuss,alternative="two.sided",var.equal=TRUE,paired=FALSE,conf.level = 0.95)
# Zwei-Stichproben-Welch-Test
t.test(meter,fuss,alternative="two.sided",var.equal=FALSE,paired=FALSE,conf.level = 0.95)

# Hypothesen des Varianzvergleichs
# H0: sig1^2 = sig2^2       versus    H1: sig1^2 <> sig2^2        O D E R
# H0: sig1^2 / sig2^2 = 1   versus    H1: sig1^2 / sig2^2 <> 1    
# Zwei-Stichproben-F-Test
var.test(meter,fuss)

# Verwendung elektronischer "Verteilungstabellen"
qt(0.975,111) # 0.975-Quantil der t(111)-Verteilung
qt(0.975,58.78) # 0.975-Quantil der t(58.78)-Verteilung
qf(0.95,43,68)# 0.95-Quantil der F(43,68)-Verteilung

# Verwendete R-Funktionen
?t.test
?var.test
?qt  # Siehe auch "dt", "pt" und "rt"
?qf  # Siehe auch "df", "pf" und "rf"

# Ende
