# +------------------------------------------------------------------------+
# | Einfuehrung in die Oekonometrie                                        |
# | Korrelationsanalyse und lineare Einfachregression                      |
# | Beispiel "PKW" (doc_pkw.pdf)                                           |
# | R. Schuhr 19.03.2012                                                   |
# + -----------------------------------------------------------------------+


# Einlesen der Daten aus der Datei "pkw.r" und Definition des Data-Frames "pkw"
# -----------------------------------------------------------------------------
pkw <- read.table("pkw.r",header=TRUE)
pkw
attach(pkw)


# Zusammenhangsanalyse: Streudiagramm, Korrelation
# ------------------------------------------------
# Streudiagramm
plot(gewicht, verbrauch, type="p", xlab="PKW-Gewicht", ylab="Benzinverbrauch", main="Streudiagramm")

# Kovarianz und Korrelation
cov(gewicht,verbrauch)                    # Kovarianz der Variablen "gewicht" und "verbrauch"
cor(gewicht,verbrauch)                    # Bravais-Pearson-Korrelationskoeffizient

# alternative Vorgehensweise ...
cov(pkw)                    # Varianz-Kovarianz-Matrix
var(gewicht)                # Auf der Hauptdiagonalen der Matrix stehen die Stichprobenvarianzen
var(verbrauch)              # der Variablen, abseits der Hauptdiagonalen steht die Kovarianz
#
cor(pkw)                    # Korrelationsmatrix (Bravais-Pearson-Korrelation)

# Unterscheidet sich der Korrelationskoeffizient signifikant von null?
# H0: rho = 0  versus  H1: rho <> 0
cor.test(gewicht, verbrauch)  

# Verwendete R-Funktionen
?cov
?cor
?cor.test


# Lineare Regressionsanalyse: Schaetzung des Regressionsmodells
# ------------------------------------------------------------
pkw.modell <- lm(verbrauch~gewicht, data=pkw) 
summary(pkw.modell)

# Ergaenzende Funktionen
vcov(pkw.modell)                # Varianz-Kovarianz-Matrix der OLS-Schaetzungen
confint(pkw.modell, level=0.95) # Konfidenzintervalle 
anova(pkw.modell)               # ANOVA

# Variablen der Klasse "pkw.modell"
pkw.modell$coefficients
pkw.modell$fitted.values
pkw.modell$residuals
verbrauch == pkw.modell$fitted.values + pkw.modell$residuals  # Test der Ergebnisse

# Plot der geschaetzten Regressionsfunktion
plot(gewicht, verbrauch, xlab="PKW-Gewicht", ylab="Benzinverbrauch", main="Regressionsfunktion")
lines(gewicht, pkw.modell$fitted.values, col="blue")

# Verwendete R-Funktionen
?lm
?confint
?summary


# Lineare Regressionsanalyse: Konfidenz- und Prognoseintervalle
# -------------------------------------------------------------
# Konfidenzintervall
clim <- predict(pkw.modell, newdata=pkw, interval="confidence", level = 0.95)
cbind(gewicht,clim)
plot(gewicht, verbrauch, xlab="PKW-Gewicht", ylab="Benzinverbrauch", main="Regressionsfunktion")
lines(gewicht, clim[,1], col="blue")
lines(gewicht, clim[,2], col="red")
lines(gewicht, clim[,3], col="red")

# Prognoseintervall
plim <- predict(pkw.modell, newdata=pkw, interval="prediction", level = 0.95)
cbind(gewicht,plim)
plot(gewicht, verbrauch, xlab="PKW-Gewicht", ylab="Benzinverbrauch", main="Regressionsfunktion")
lines(gewicht, plim[,1], col="blue")
lines(gewicht, plim[,2], col="green")
lines(gewicht, plim[,3], col="green")

# "Echte" Prognose
npkw <- data.frame(gewicht=1.5)
npkw
predict(pkw.modell, newdata=npkw, interval="prediction", level = 0.90)


# Verwendete R-Funktionen
?predict
?predict.lm
?matplot
?text


# Lineare Regressionsanalyse: Residuenanalyse
# -------------------------------------------
# Residuen-Plot Variante 1
plot(gewicht, pkw.modell$residuals, xlim=c(0.8,2), ylim=c(-1.5,1.5),
     xlab="PKW-Gewicht", ylab="Residuen", main="Residuenplot")
abline(h=0.0, col="red")
# Residuen-Plot Variante 2
plot(pkw.modell$fitted.values, pkw.modell$residuals, xlim=c(5,12), ylim=c(-1.5,1.5),
     xlab="angepasste Werte", ylab="Residuen", main="Residuenplot")
abline(h=0.0, col="red")

# Residuen-Normalverteilungscheck
qqnorm(pkw.modell$residuals) # Normal-QQ-Plot der Residuen
qqline(pkw.modell$residuals)
shapiro.test(pkw.modell$residuals) # Shapiro-Wilks-Tests der Residuen
studres <- rstudent(pkw.modell) # Berechnung der "studentisierten" Residuen
qqnorm(studres)  # QQ-Plot der "studentisierten" Residuen
qqline(studres)
shapiro.test(studres) # Shapiro-Wilks-Tests

# Verwendete R-Funktionen
?qqnorm
?qqline
?shapiro.test
?rstudent

detach(pkw)  # Ende