# +--------------------------------------------------------------------------+
# | Einfuehrung in die Oekonometrie                                          |
# | Lineare Einfachregression und Variablentransformation                    |
# | Beispiel "Windkraftanlage" (doc_windkraft.pdf)                           | 
# | R. Schuhr 22.03.2012                                                     |
# + -------------------------------------------------------------------------+


# Einlesen der Daten aus der Datei "windkraft.r" und Definition des Data-Frames "wind"
# -----------------------------------------------------------------------------------
wind <- read.table("windkraft.r",header=TRUE)
wind
attach(wind)


# Streudiagramm
# -------------
plot(speed, power, xlab="Windgeschwindigkeit", ylab="Stromstaerke")


# Lineare Einfachregression
# -------------------------
modell <- lm(power~speed)
summary(modell)

# Regressionsplot und Residuenplots
# ---------------------------------
plot(speed, power, xlab="Windgeschwindigkeit", ylab="Stromstaerke")
lines(speed, modell$fitted.values)
plot(speed, modell$residuals, xlab="Windgeschwindigkeit", ylab="Residuen")
abline(h=0)
plot(modell$fitted.values, modell$residuals, xlab="Angepasste Werte", ylab="Residuen")
abline(h=0)


# Explorative Datenanalyse: Datentransformationen zur Linearisierung des Zusammenhangs
# ------------------------------------------------------------------------------------
x <- speed**0.5
plot(x, power, xlab="Windgeschwindigkeit - Quadratwurzel", ylab="Stromstaerke")
abline(lm(power~x))

x <- log(speed)
plot(x, power, xlab="Windgeschwindigkeit - Logarithmus", ylab="Stromstaerke")
abline(lm(power~x))

x <- -speed**-0.5
plot(x, power, xlab="Windgeschwindigkeit - 1/Quadratwurzel", ylab="Stromstaerke")
abline(lm(power~x))

x <- -speed**-1
plot(x, power, xlab="Windgeschwindigkeit - Kehrwert", ylab="Stromstaerke")
abline(lm(power~x))


# Regressionsanalyse: Schaetzung des Regressionsmodells
# -----------------------------------------------------
modell <- lm(power~x, data=wind)
summary(modell)
confint(modell, level = 0.95)

# Plot der geschaetzten Regressionsfunktion - Transformierte Abzsisse
plot(x, power, xlab="Windgeschwindigkeit - Kehrwert", ylab="Stromstaerke", main="Regressionsfunktion")
lines(x, modell$fitted.values, col="blue")

# Plot der geschaetzten Regressionsfunktion - Original Abzsisse
plot(speed, power, xlab="Windgeschwindigkeit", ylab="Stromstaerke", main="Regressionsfunktion")
lines(speed, modell$fitted.values, col="blue")


# Verwendete R-Funktionen
?lm
?confint
?summary
?abline


# Regressionsanalyse: Konfidenz- und Prognoseintervalle
# -----------------------------------------------------
clim <- predict(modell, wind, interval="confidence", level = 0.95)
plot(speed, power, xlab="Windgeschwindigkeit", ylab="Stromstaerke", main="Regressionsfunktion")
lines(speed, clim[,1], col="blue")
lines(speed, clim[,2], col="red")
lines(speed, clim[,3], col="red")

plim <- predict(modell, wind, interval="prediction", level = 0.95)
plot(speed, power, xlab="Windgeschwindigkeit", ylab="Stromstaerke", main="Regressionsfunktion")
lines(speed, plim[,1], col="blue")
lines(speed, plim[,2], col="green")
lines(speed, plim[,3], col="green")


# Verwendete R-Funktionen
?predict
?predict.lm


# Regressionsanalyse: Residuenanalyse
# -----------------------------------
# Residuen-Plot Variante 1
plot(speed, modell$residuals, xlim=c(2,18), ylim=c(-2.5,2.5),
     xlab="Windgeschwindigkeit", ylab="Residuen", main="Residuenplot")
abline(h=0.0)
# Residuen-Plot Variante 2
plot(modell$fitted.values, modell$residuals, xlim=c(0,25), ylim=c(-2.5,2.5),
     xlab="angepasste Werte", ylab="Residuen", main="Residuenplot")
abline(h=0.0)

# Residuen-Normalverteilungscheck
studres <- rstudent(modell) # Berechnung der "studentisierten" Residuen
qqnorm(studres)  # QQ-Plot der "studentisierten" Residuen
qqline(studres)
shapiro.test(studres) # Shapiro-Wilks-Tests

# Verwendete R-Funktionen
?qqnorm
?qqline
?shapiro.test
?rstudent

detach(wind)  # Ende