# +--------------------------------------------------------------------------+
# | Einfuehrung in die Oekonometrie                                          |
# | Lineare Mehrfachregression - Schritt fuer Schritt                        |
# | Beispiel "Mietspiegel Muenchen 1999" (doc_mietspiegel99.pdf)             |
# | R. Schuhr 19.03.2012                                                     |
# + -------------------------------------------------------------------------+


# Einlesen der Daten aus der Datei "miete99.csv" und Definition des Data-Frames "msm"
# -----------------------------------------------------------------------------------
# Hinweis: Die Datei miete99.csv enthaelt eine Teilmenge der Daten aus der Datei mietspiegel99.csv.
# Enthalten sind Daten zu Wohnungen mit normaler Ausstattung, die in oder nach 1970 gebaut wurden.

msm <- read.csv2("c:/oeksofia/miete99.csv",header=TRUE)
dim(msm)
msm[1:20,]
attach(msm)


# Streudiagramme
# --------------
plot(flaeche, miete, xlab="Wohnflaeche in qm", ylab="Miete in DM", main="Mietepreise in Muenchen 1999")
plot(flaeche, log(miete), xlab="Wohnflaeche in qm", ylab="log(Miete)", main="Mietepreise in Muenchen 1999")
# Die Log-Transformation fuehrt zu einer Stabilisierung inhomogener (= heteroskedastischer) Stoervarianzen.


# Lineare Mehrfachregression - Kompakt
# ------------------------------------
msm.modell <- lm(log(miete)~flaeche+lage.+lage.., data=msm)
summary(msm.modell)
# Interpretation der Regressionskoeffizienten
msm.modell$coeff
exp(msm.modell$coeff)

# Verwendete R-Funktionen
?lm
?summary
?log


# Lineare Mehrfachregression - Schritt fuer Schritt
# -------------------------------------------------
# Matrizen
X <- matrix(1,799,4)
X[,2] <- msm$flaeche 
X[,3] <- msm$lage.
X[,4] <- msm$lage..
X[1:10,]
dim(X)
y <- matrix(log(msm$miete),799,1)
dim(y)
# Verwendete R-Funktionen
?matrix
?dim

# Berechnung der OLS-Schaetzwerte
Xt <- t(X)              # Transponieren von X
dim(Xt)
XtX <- Xt%*%X           # Kreuzproduktmatrix, Matrizenprodukt %*%
XtX
Xty <- Xt%*%y
Xty
b <- solve(XtX,Xty)     # Berechnen der OLS-Schaetzwerte fuer b durch Loesen 
b                       # der Normalgleichungen XtX%*%b=Xty

# oder ...

XtXinv <- solve(XtX)    # Invertieren einer regulaeren quadratischen Kreuzproduktmatrix
XtXinv
XtX%*%XtXinv            # Probe
b <- XtXinv%*%Xty       # Berechnen der OLS-Schaetzwerte
b

# Verwendete R-Funktion
?t
?solve

# Hat-Matrix H
H <- X%*%XtXinv%*%Xt 
dim(H)

# Graphiken
fit <- X%*%b            # Geschaetzte (angepasste) Werte des Regressanden und Residuen
# oder ...
fit <- H%*%y            
res <- y-fit            # Residuen

# Streudiagramm fit versus log(miete)
plot(fit, log(miete), xlab="Fitted Values", ylab="log(Miete)", main="Mietepreise in Muenchen 1999")
lines(fit, fit, type="l") 

# Streudiagramm exp(fit) versus miete
plot(exp(fit), miete, xlab="exp(Fitted Values)", ylab="Miete in DM", main="Mietepreise in Muenchen 1999")
lines(exp(fit), exp(fit), type="l") 

# Residuendiagramm
plot(fit, res, type="p",  xlab="Fitted Values", ylab="Residuen", main="Residuenplot") 
abline(h=0)

# Verwendete R-Funktionen
?plot
?lines
?abline

# Streuungszerlegung
TSS <- sum((log(miete)-mean(log(miete)))**2)  # total sum of squares
ESS <- sum((fit-mean(fit))**2)                # regression sum of squares
RSS <- sum(res**2)                            # residual sum of squares
TSS
ESS+RSS
ESS
RSS
R2  <- ESS/TSS                                # Bestimmtheitsmass
R2
# oder ...
R2  <- 1-(RSS/TSS)
R2

# Standardfehler der Schaetzungen
E.Var <- RSS/(799-4)                        # Schaetzung der Stoervarianz
E.Var
E.Sig <- E.Var**0.5                         # Schaetzung der Stoerstandardabweichung
E.Sig
b.Var <- E.Var*XtXinv                       # Varianz-Kovarianz-Matrix der geschaetzten Regressionskoeffizienten
b.Var
diag(b.Var)                                 # Varianzen der geschaetzten Regressionskoeffizienten
b.Sig <- sqrt(diag(b.Var))                  # Standardfehler der geschaetzten Regressionskoeffizienten
b.Sig

# t-Tests
t0 <- b[1,1] / b.Sig[1]                     # Test der Hypothese H0: b0==0 mit alpha=0.01
tkrit <- qt(0.995, 799-4)
t0
tkrit
abs(t0) >= tkrit                            # H0 wird verworfen. 
t1 <- b[2,1] / b.Sig[2]                     # Test der Hypothese H0: b1==0 mit alpha=0.01
t1
tkrit
abs(t1) >= tkrit                            # H0 wird verworfen. 
t2 <- b[3,1] / b.Sig[3]                     # Test der Hypothese H0: b2==0 mit alpha=0.01
t2
tkrit
abs(t2) >= tkrit                            # H0 wird verworfen. 
t3 <- b[4,1] / b.Sig[4]                     # Test der Hypothese H0: b3==0 mit alpha=0.01
t3
tkrit
abs(t3) >= tkrit                            # H0 wird verworfen. 
# Verwendete R-Funktionen
?diag
?qt
?abs


detach(msm) # Ende
